/*
 * This source obtained from 's' file on 87/01/19 at 17:53:35
*/

static char *_Version = " @(#) sub.c ver. 1.9 87/04/22";

/*
 *   TITLE   sub.c
 *
 *
 *   Copyright 1986, by Ryan-McFarland
 *   Corporation.  All rights reserved.
 *
 *   The information contained in this document is
 *   proprietary  to  Ryan-McFarland  Corporation,
 *   and provided  for maintenance purposes  only.
 *   No other use  of this  material is authorized
 *   or permitted without  specific authorization,
 *   in writing, from  Ryan-McFarland Corporation.
 *
 ****************************************************************************/


#include <stdio.h>
#include <errno.h>

#include "rmc85call.h"
#define NAMSIZ	256	

			/* define all routines as integer */
int subsys(), subren(), subdel();

				/* define library header */
struct PROCTABLE LIBTABLE[] =
	{
		{ "SYSTEM", subsys},
		{ "RENAME", subren},
		{ "DELETE", subdel},
		{ 0, 0 }
	};

				/* submit system command as if it was
					typed in at shell prompt
					parameter 1 must be null terminated */
int subsys(name, arg_count, arg_vector, initial)
char *name;
int arg_count;
struct ARGUMENT_ENTRY arg_vector[];
int initial;
{

	char command[BUFSIZ];	/* buffer for ASCIIZ string for command */

				/* make sure we where passed a command */
	if (arg_count != 1){
		return( RM_STOP);
	}

	resetunit();		/* reset terminal to original state */

				/* convert argument to ASCIIZ string */
	wstoasc( &arg_vector[0], command);

					
	system( command);	/* submit command */	

	setunit();		/* return terminal to Cobol state */

	return( RM_FND);			/* return OK */

}

int subren(name, arg_count, arg_vector, initial)
char *name;
int arg_count;
struct ARGUMENT_ENTRY arg_vector[];
int initial;
{
				/* buffers for names if called with 85
					calling sequence */
	char	from[NAMSIZ], to[NAMSIZ],
		*clean;		/* temp variable for delete 
					of trailing spaces */

				/* make sure we were called with an argument */
	if ( arg_count < 1) {
		return( RM_STOP);
	}
	else
	{			/* if only 1 argument assume 2n calling
					sequence */
		if ( arg_count == 1){
			return( sub21ren( arg_vector[0].a_address));
		}
	}	
			/* else assume 2 arguments */
		
				/* convert ws names to ASCIIZ strings */
	wstoasc( &arg_vector[0], from);
	wstoasc( &arg_vector[1], to);

				/* clean up trailing spaces */
	for( clean=from; *clean != ' ' && *clean != '\0'; clean++);
	*clean = '\0';
	for( clean=to; *clean != ' ' && *clean != '\0'; clean++);
	*clean = '\0';

				/* create link for new file name */
				/* unlink old file name only if link was
					successful */
	if (!link( from, to)){
		unlink( from);
	}

	return( RM_FND);
}

int subdel(subname, arg_count, arg_vector, initial)
char *subname;
int arg_count;
struct ARGUMENT_ENTRY arg_vector[];
int initial;
{

	char	name[NAMSIZ],	/* buffer for new style variable name */
		*clean;		/* temp variable for delete 
					of trailing spaces */

	if ( arg_count != 1) {
		return( RM_STOP);
	}
				
				/* convert ws names to ASCIIZ strings */
	wstoasc( &arg_vector[0], name);

				/* clean up trailing spaces */
	for( clean=name; *clean != ' ' && *clean != '\0'; clean++);
	*clean = '\0';
	
	unlink ( name);		/* delete the file */

	return( RM_FND);
}

/*  
    This routine supplied to allow compatibility with version 2.N
    calling sequences for the RENAME routine.
*/

int sub21ren( path)
char *path;
{
	char command[NAMSIZ];

	strcpy( command, "mv ");	/* use the UNIX mv command */
	strcat( command, path);		/* add the pathnames to command line */

	system( command);		/* submit system command for rename */

	return( RM_FND);		/* return OK */

}

/*
    This routine will take the first argument and copy all
    characters into name adding the terminating null so name 
    can be used with C functions link printf, link, system etc...
*/

int wstoasc( arg, name)
struct ARGUMENT_ENTRY *arg;
char *name;
{

	register int idx;	/* use register as loop counter */
	char *c;		/* current location in input string */

				/* loop thru the arguments to make
					null terminated C strings */
	for(c=arg->a_address, idx=arg->a_length;
	    idx; 
	    idx--,c++,name++){
		if ((*c < ' ') || (*c > '~')){
			*name = '\0';
		}
		else
		{
			*name = *c;
		}
	}

	*name = '\0';		/* add trailing null character */

	return( 0);
}
